! calculate generalised inverse of real symmetric, halfstored matrix
! input file: non-zero elements of matrix, one line per element
!             -> row no., column no., element  (space separated)
! program will ask for file name & no. of rows/columns
!                                                        karin meyer

program ginverse 

implicit none
real(8), dimension(:), allocatable :: avec
real(8)                            :: xx, det, zero=1.d-9
character(len=30)                  :: fname
logical                            :: lex
integer                            :: neqns, i, j, n, ii, nrank, ij
integer, external                  :: ihmssf

! get file name
write(*,*)'Give name of input file (max 30 char.s): '
read(*,'(a)',iostat=ii) fname
if(ii/=0) then
   write(*,*)'error trying to read file name'; stop
end if

! open file
inquire(file=trim(fname),exist=lex)
if( .not. lex )then
   write(*,*)'file "',trim(fname),'" does not seem to exist'; stop
end if
open(1,file=trim(fname),status='old',form='formatted',action='read')
write(*,*)'"',trim(fname),'" opened '

write(*,*)'Give size (no. of rows/columns) of matrix: '
read(*,*,iostat=ii) neqns
if(ii/=0) then
   write(*,*)'error trying to number'; stop
end if
write(*,*)'No. of rows/columns specified  = ',neqns

! allocate matrix
allocate(avec(neqns*(neqns+1)/2), stat=ii)
if( ii/= 0 ) then
    write(*,*)'error trying to allocate matrix'; stop
end if

! read matrix
n=0; avec=0.d0
do
  read(1,*,iostat=ii) i, j, xx;  if( ii/=0 )exit
  if(i < 1 .or. i > neqns .or. j<1 .or. j> neqns ) then
     write(*,*)'invalid row or column no. encountered', i,j,xx; stop
  end if
  avec(ihmssf(i,j,neqns)) = xx;   n=n+1
end do
write(*,*)'No. of elements in matrix found =',n
close(1)

! invert
call dkmxhf( avec, det, zero, nrank, neqns, .true.)
write(*,*)'Inversion done'
write(*,*)'Rank of matrix                  =',nrank
write(*,*)'Log determinant                 =', det
n = count(mask=(avec/=0))
write(*,*)'No. of non-zero elements        =',n

! write out matrix: 1st line has determinant & no. of elements!
open(2,file='ginverse.out')
write(2,*)det,n
! ... following lines have non-zero elements
do i=1,neqns
   do j=1,i
      ij = ihmssf(i,j,neqns); if( avec(ij) == 0 ) cycle
      write(2,'(2i10,g18.8)')j,i,avec(ij)
   end do
end do
write(*,*)'Output file is: "ginverse.out" '
stop
end program ginverse

! =======================================================================
  subroutine dkmxhf( a, det, zero, nrank, n, iopt)
! =======================================================================

  implicit none
  integer, intent(in)                          :: n
  logical, intent(in)                          :: iopt
  real(8), dimension(n*(n+1)/2), intent(inout) :: a
  real(8), intent(in)                          :: zero
  real(8), intent(out)                         :: det
  integer, intent(out)                         :: nrank
  real(8), dimension(n)                        :: v, w
  integer, dimension(n)                        :: iflag
  real(8)                                      :: ww, xx, dmax, &
&                                                 amax, bmax, dimax
  integer                                      :: ii,i1,n1,il,imax, &
&                                                 imaxm1,imaxp1,ij,j,i,neg

!     ------------------
!     MATRIX IS A SCALAR
!     ------------------

      IF(N.EQ.1)THEN
         IF(a(1).GT.ZERO)THEN
            DET=DLOG( a(1) ); A(1)=1.D0/a(1); NRANK=1
         ELSE
            A(1)=0.D0; NRANK=0; DET=0.D0
         END IF
         RETURN
      END IF

!     ----------
!     INITIALIZE
!     ----------

      NEG=0; DET=0.D0; IFLAG=0;  N1=N+1

!     PICK OUT DIAGONAL ELEMENTS
      II=-N
      DO I=1,N
         II=II+N1; W(I)=A(II); II=II-I
      END DO

!     --------------------------
!     GAUSSIAN ELIMINATION STEPS
!     --------------------------

      DO 100 II=1,N

!     FIND DIAG. ELEMENT WITH LARGEST ABSOLUTE VALUE (PIVOT)
      DMAX=0.D0;  AMAX=0.D0
      DO I=1,N
         IF(IFLAG(I).NE.0) cycle
         BMAX=DABS(W(I))
         IF(BMAX.GT.AMAX)THEN
            DMAX=W(I); AMAX=BMAX; IMAX=I
         END IF
      end do

!     CHECK FOR SINGULARITY
      IF(AMAX.LE.ZERO)GO TO 11
      IF(IOPT .AND. AMAX.LT.1.D-5) PRINT *,'SMALL PIVOT ',II,DMAX
!     SET FLAG
      IFLAG(IMAX)=II
!     ACCUMULATE LOG DETERMINANT
      DET=DET+DLOG(AMAX)
      IF(DMAX.LT.0.D0)THEN
         NEG=NEG+1
         IF(IOPT)PRINT *,'NEGATIVE PIVOT, IGNORE SIGN FOR LOG DET' &
     &                       ,II,IMAX,DMAX
      END IF

      DIMAX = 1.D0/DMAX
      IMAXM1 = IMAX-1; IMAXP1 = IMAX+1

!     PICK OUT ELEMENTS FOR ROW IMAX
      IL=IMAX-N
      DO I=1,IMAXM1
         IL=IL+N1-I; V(I)=A(IL)
      end do
      IL=IL+N1-IMAX
      DO I=IMAXP1,N
         IL=IL+1; V(I)=A(IL)
      end do

!     TRANSFORM MATRIX
      IJ=0
      DO I=1,IMAXM1
      WW = V(I)
      IF(WW /= 0.D0)THEN
         XX = WW*DIMAX
         IJ = IJ+1; W(I) = W(I) - WW*XX
         DO J=I+1,IMAXM1
            IJ=IJ+1
            if( v(j) /= 0) A(IJ) = A(IJ)-XX*V(J)
         end do
!        ELEMENT A(I,IMAX)
         IJ=IJ+1; A(IJ) = XX
         DO J = IMAXP1,N
            IJ=IJ+1
            if( v(j) /= 0) A(IJ) = A(IJ)-XX*V(J)
         end do
      ELSE
         IJ=IJ+N1-I
      END IF
      end do

!     ROW IMAX
      IJ=IJ+1; W(IMAX)=-DIMAX
      DO J = IMAXP1,N
         IJ=IJ+1; A(IJ)=V(J)*DIMAX
      end do

      DO  I=IMAXP1,N
         WW=V(I)
         IF(WW /= 0.D0)THEN
            XX=WW*DIMAX; IJ=IJ+1; W(I)=W(I)-WW*XX
            DO J=I+1,N
               IJ=IJ+1; A(IJ)=A(IJ)-XX*V(J)
            end do
         ELSE
            IJ=IJ+N1-I
         END IF
      end do
 100  CONTINUE

!     ------------------------------------
!     STORE DIAGONALS BACK & REVERSE SIGNS
!     ------------------------------------

      IJ=0
      DO I=1,N
         IJ=IJ+1; WW=-W(I); W(I)=WW; A(IJ)=WW
         DO J=I+1,N
            IJ=IJ+1; A(IJ)=-A(IJ)
         end do
      end do
      NRANK=N

 300  IF(IOPT .AND. NEG.GT.0)PRINT *,'NO. OF NEGATIVE PIVOTS =', NEG
      if( iopt .and. mod(neg,2) /= 0 ) write(*,*)'dkmxhf : uneven no. of negative pivots',&
&                          ' - log determinant not correct !'
      RETURN

!      ---------------------------------------------------
!      MATRIX NOT OF FULL RANK, RETURN GENERALISED INVERSE
!      ---------------------------------------------------

   11 NRANK=II-1; IJ=0

      DO I=1,N
      IF(IFLAG(I) == 0)THEN
!        ... ZERO OUT ROW/COLUMN
         W(I)=0.D0
         DO J=I,N
            IJ=IJ+1;  A(IJ)=0.D0
         end do
      ELSE
         IJ=IJ+1
         WW=-W(I); W(I)=WW; A(IJ)=WW
         DO J=I+1,N
            IJ=IJ+1
            IF(IFLAG(J).NE.0)THEN
               A(IJ)=-A(IJ)
            ELSE
               A(IJ)=0.D0
            END IF
         end do
      END IF
      end do

      IF(IOPT)PRINT 15,N,NRANK
   15 FORMAT(' GENERALISED INVERSE OF MATRIX WITH ORDER =',I5,'   AND RANK =',I5)
      GO TO 300
      END subroutine dkmxhf

! ===============================
  INTEGER FUNCTION IHMSSF(I,J,N)
! ===============================

  implicit none
  integer, intent(in) :: i, j, n
  integer             :: i1, j1

  IF(I.LE.J)THEN
     I1=I-1; IHMSSF=N*I1-I*I1/2+J
  ELSE
     J1=J-1; IHMSSF=N*J1-J*J1/2+I
  END IF

  RETURN
  END function ihmssf
